<?php
class PortalFront extends Portal
{
  public $zalogowany = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany = $this->getActualUser();
  }
  
  function getActualUser()
  {
    if(isset($_SESSION['zalogowany'])){
      return $_SESSION['zalogowany'];
    }
    else{
      return null;
    }
  }
  
  function setMessage($komunikat)
  {
    $_SESSION['komunikat'] = $komunikat;
  }
  
  function getMessage()
  {
    if(isset($_SESSION['komunikat'])){
      $komunikat = $_SESSION['komunikat'];
      unset($_SESSION['komunikat']);
      return $komunikat;
    }
    else {
      return null;
    }
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy uytkownik ju jest zalogowany
    if($this->zalogowany){
      return NO_LOGIN_REQUIRED;
    }
    
    //Sprawdzenie czy zostay przekazane parametry
    if(!isset($_POST["email"]) || !isset($_POST["haslo"])){
      return FORM_DATA_MISSING;
    }
    
    $user = $_POST["email"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie dugoci przekazanych cigw
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    //$userNameLength = strlen(utf8_decode($user));
    //$userPassLength = strlen(utf8_decode($pass));
    //lub
    $userEmailLength = mb_strlen($user, 'utf8');
    $userPassLength = mb_strlen($pass, 'utf8');
    
    if($userEmailLength < 5 || $userEmailLength > 250 ||
     $userPassLength < 6 || $userPassLength > 100){
      return ACTION_FAILED;
    }
  
    //Zabezpieczenie znakw specjalnych w parametrach
    $email = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzajcego poprawno danych
    $query = "SELECT `Id`, `Imi`, `Nazwisko`, `Haso` "
           . "FROM Klienci WHERE `Email`='$email'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystpi bd: nieprawidowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wynikw zapytania.
    if($result->num_rows <> 1){
      //Brak uytkownika o wskazanej nazwie lub zbyt wiele wynikw
      return ACTION_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[3];
      //Wersja bez kodowania hase
      if($pass != $pass_db){
      //Wersja z kodowaniem hase
      //if(crypt($pass, $pass_db) != $pass_db){
        return ACTION_FAILED;
      }
      else{
        $nazwa = $row[1] . ' ' . $row[2];
        $_SESSION['zalogowany'] = new User($row[0], $nazwa);
        return ACTION_OK;
      }
    }
  }
  
  function logout()
  {
    $this->zalogowany = null;
    if(isset($_SESSION['zalogowany'])){
      unset($_SESSION['zalogowany']);
      
      //Jeli sesja ma by usunita (co wie si te z usuniciem koszyka):
      /*
      if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();
      */
    }
  }
  
  function showRegistrationForm()
  {
    $reg = new Registration($this->dbo);
    return $reg->showRegistrationForm();
  }
  
  function registerUser()
  {
    $reg = new Registration($this->dbo);
    return $reg->registerUser();
  }
  
  function showSearchForm()
  {
    $autor = filter_input(INPUT_GET, 'autor', FILTER_SANITIZE_SPECIAL_CHARS);
    $tytu = filter_input(INPUT_GET, 'tytul', FILTER_SANITIZE_SPECIAL_CHARS);
    include 'templates/searchForm.php';
  }
  
  //Tutaj pozostae metody klasy
}
?>